<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pages extends Eloquent {

	protected $table = 'pages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'excerpt', 'body', 'image', 'slug', 'meta_description', 'meta_keywords', 'status');
	protected $visible = array('title', 'excerpt', 'body', 'image', 'slug', 'meta_description', 'meta_keywords', 'status');

	public function author()
	{
		return $this->hasOne('TCG\Voyager\Models\User');
	}

}