<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserSection extends Eloquent {

	protected $table = 'user_sections';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->morphMany('User', 'usable');
	}

	public function groups()
	{
		return $this->hasMany('UserGroup');
	}

}