<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id');
			$table->bigInteger('admin_id');
			$table->bigInteger('booking_id');
			$table->bigInteger('subscription_id');
			$table->text('messages');
			$table->enum('notification_type', array('sms', 'email'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}