<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 250);
			$table->text('description');
			$table->decimal('price', 10,2);
			$table->enum('status', array('active', 'inActive'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}