<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id');
			$table->bigInteger('package_id');
			$table->date('start_date');
			$table->date('end_date');
			$table->decimal('total_price', 10,2);
			$table->bigInteger('branch_id');
			$table->enum('payment_status', array('pending', 'paid', 'partial'));
			$table->enum('status', array('active', 'expired', 'canceled'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}