<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OptionCategory extends Model 
{

    protected $table = 'option_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'min', 'max', 'description_en', 'description_ar', 'store_id');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

}