<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StorePayment extends Model 
{

    protected $table = 'store_payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('payment_id', 'store_id');

    public function payment()
    {
        return $this->belongsTo('PaymentMethod', 'payment_id');
    }

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

}