<?php

namespace Class;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Class extends Eloquent {

	protected $table = 'classes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');

	public function categories()
	{
		return $this->hasMany('Category\Category');
	}

	public function products()
	{
		return $this->hasMany('Class\Class');
	}

}