<?php

namespace CustomerType;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CustomerType extends Eloquent {

	protected $table = 'customer_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'deleted_by', 'created_by', 'updated_by');

	public function customer()
	{
		return $this->hasMany('Customer\Customer');
	}

}