<?php

namespace Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'sku', 'details', 'height', 'weight', 'length', 'width', 'active');

	public function class()
	{
		return $this->belongsTo('Class\Class', 'class_id');
	}

	public function category()
	{
		return $this->belongsTo('Category\Category', 'category_id');
	}

	public function subCategory()
	{
		return $this->belongsTo('Category\Category', 'subategory_id');
	}

	public function brand()
	{
		return $this->belongsTo('Brand\Brand', 'brand_id');
	}

	public function stores()
	{
		return $this->belongsToMany('Store\Store', 'product_stores');
	}

}