<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketTable extends Migration {

	public function up()
	{
		Schema::create('ticket', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description');
			$table->timestamp('duedate');
			$table->timestamp('last_update');
			$table->string('priority');
			$table->timestamp('created');
			$table->integer('dept_id')->unsigned();
			$table->integer('team_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('status_id')->unsigned();
			$table->integer('project_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('ticket');
	}
}