<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBasketsTable extends Migration {

	public function up()
	{
		Schema::create('Baskets', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->string('Title')->nullable()->default('shop basket');
			$table->integer('UserId')->unique()->unsigned();
			$table->string('Total');
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Baskets');
	}
}