<?php

namespace shop.Category;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'Category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'Title', 'created_at');

    public function episodes()
    {
        return $this->belongsTo('Episodes', 'CategoryId');
    }

}