<?php

namespace shop.Payments;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payments extends Model 
{

    protected $table = 'Payments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'UserId', 'Cost', 'DiscountId', 'Transaction_ID', 'created_at');

    public function user()
    {
        return $this->hasMany('Payments');
    }

    public function payments()
    {
        return $this->belongsTo('Users');
    }

    public function discount()
    {
        return $this->hasMany('Payments');
    }

    public function payments()
    {
        return $this->belongsTo('Discounts');
    }

}