<?php

namespace shop.Episodes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Episodes extends Eloquent {

	protected $table = 'Episodes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'Title', 'Price', 'Duration', 'Cover', 'CategoryId');

	public function category()
	{
		return $this->hasMany('Episodes', 'CategoryId');
	}

	public function sessions()
	{
		return $this->belongsTo('Sessions');
	}

}