<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->enum('gender', array('male', 'female'));
			$table->string('email', 255);
			$table->enum('email_status', array('active', 'inactive'));
			$table->string('phone', 255);
			$table->enum('phone_status', array('active', 'inactive'));
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->string('address', 255);
			$table->string('level', 10);
			$table->enum('type', array('supervisor', 'competitors'));
			$table->string('alternative_address', 255);
			$table->timestamps();
			$table->json('identity');
			$table->softDeletes();
			$table->string('nationality', 20);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}