<?php

namespace App;

class DonationRequest extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('patient_name', 'patient_age', 'bags_number', 'hospital_name', 'hosiptal_latitude', 'hospital_longitude', 'phone', 'blood_type_id', 'notes');

	public function client()
	{
		return $this->belongsTo('App\Client');
	}

	public function city()
	{
		return $this->belongsTo('App\City');
	}

	public function bloodType()
	{
		return $this->belongsTo('App\BloodType');
	}

	public function notification()
	{
		return $this->hasOne('App\Notification');
	}

}