<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'date_of_birth', 'phone', 'blood_type_id', 'password', 'city_id');
    protected $hidden = array('password');

    public function city()
    {
        return $this->belongsTo('App\City');
    }

    public function donationRequests()
    {
        return $this->hasMany('App\DonationRequest');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Notification');
    }

    public function reports()
    {
        return $this->hasMany('App\Contact');
    }

    public function cities()
    {
        return $this->belongsToMany('App\City');
    }

    public function bloodType()
    {
        return $this->belongsTo('App\BloodType');
    }

    public function bloodTypes()
    {
        return $this->belongsToMany('App\BloodType');
    }

    public function articles()
    {
        return $this->belongsToMany('App\Article');
    }

}