<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('organizers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('speakers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('organizer_id')->references('id')->on('organizers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('portfolios', function(Blueprint $table) {
			$table->foreign('speaker_id')->references('id')->on('speakers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_pictures', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_prices', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_hustles', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_hustles', function(Blueprint $table) {
			$table->foreign('speaker_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('follow_organizers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('follow_organizers', function(Blueprint $table) {
			$table->foreign('organizer_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('follow_speakers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('follow_speakers', function(Blueprint $table) {
			$table->foreign('speaker_id')->references('id')->on('speakers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('speaker_skills', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skill_lists')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('speaker_skills', function(Blueprint $table) {
			$table->foreign('speaker_id')->references('id')->on('speakers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('organizers', function(Blueprint $table) {
			$table->dropForeign('organizers_user_id_foreign');
		});
		Schema::table('speakers', function(Blueprint $table) {
			$table->dropForeign('speakers_user_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_organizer_id_foreign');
		});
		Schema::table('portfolios', function(Blueprint $table) {
			$table->dropForeign('portfolios_speaker_id_foreign');
		});
		Schema::table('event_pictures', function(Blueprint $table) {
			$table->dropForeign('event_pictures_event_id_foreign');
		});
		Schema::table('event_prices', function(Blueprint $table) {
			$table->dropForeign('event_prices_event_id_foreign');
		});
		Schema::table('event_hustles', function(Blueprint $table) {
			$table->dropForeign('event_hustles_event_id_foreign');
		});
		Schema::table('event_hustles', function(Blueprint $table) {
			$table->dropForeign('event_hustles_speaker_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_user_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_event_id_foreign');
		});
		Schema::table('follow_organizers', function(Blueprint $table) {
			$table->dropForeign('follow_organizers_user_id_foreign');
		});
		Schema::table('follow_organizers', function(Blueprint $table) {
			$table->dropForeign('follow_organizers_organizer_id_foreign');
		});
		Schema::table('follow_speakers', function(Blueprint $table) {
			$table->dropForeign('follow_speakers_user_id_foreign');
		});
		Schema::table('follow_speakers', function(Blueprint $table) {
			$table->dropForeign('follow_speakers_speaker_id_foreign');
		});
		Schema::table('speaker_skills', function(Blueprint $table) {
			$table->dropForeign('speaker_skills_skill_id_foreign');
		});
		Schema::table('speaker_skills', function(Blueprint $table) {
			$table->dropForeign('speaker_skills_speaker_id_foreign');
		});
	}
}