<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'type');
    protected $visible = array('name', 'type');

    public function files()
    {
        return $this->belongsToMany('App\File', 'categories_files');
    }

    public function events()
    {
        return $this->belongsToMany('App\Event', 'categories_events');
    }

}