<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('email_verified_at', 'password', 'firstname', 'gender', 'lastname', 'address', 'sub_address', 'zip_code', 'city', 'cedex', 'phone_number', 'picture', 'email', 'role', 'url', 'job', 'description', 'locale', 'organism', 'stopMail');
	protected $visible = array('email_verified_at', 'firstname', 'gender', 'lastname', 'address', 'sub_address', 'zip_code', 'city', 'cedex', 'phone_number', 'picture', 'email', 'role', 'url', 'job', 'description', 'locale', 'organism', 'stopMail');
	protected $hidden = array('password');

	public function groups()
	{
		return $this->belongsToMany('App\Group', 'groups_users');
	}

	public function events()
	{
		return $this->belongsToMany('App\Event', 'events_users');
	}

	public function picture()
	{
		return $this->belongsTo('App\File', 'picture');
	}

	public function folders()
	{
		return $this->belongsToMany('App\Folder', 'folders_users');
	}

	public function files()
	{
		return $this->hasMany('App\File', 'author');
	}

}