<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('email');

    public function notations()
    {
        return $this->hasMany('\Notation');
    }

    public function jobAdverts()
    {
        return $this->hasMany('\JobAdvert');
    }

    public function courseAdverts()
    {
        return $this->hasMany('\CourseAdvert');
    }

    public function cvs()
    {
        return $this->hasMany('\Cv');
    }

    public function addresses()
    {
        return $this->hasMany('\Address');
    }

}