<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('exercise', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('exercise_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exercise_category', function(Blueprint $table) {
			$table->foreign('parent')->references('id')->on('exercise_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainer', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainer_photos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('before_after_photos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('training_package', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainer_comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trainer_comments', function(Blueprint $table) {
			$table->foreign('commenter')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('exercise', function(Blueprint $table) {
			$table->dropForeign('exercise_category_id_foreign');
		});
		Schema::table('exercise_category', function(Blueprint $table) {
			$table->dropForeign('exercise_category_parent_foreign');
		});
		Schema::table('trainer', function(Blueprint $table) {
			$table->dropForeign('trainer_user_id_foreign');
		});
		Schema::table('trainer_photos', function(Blueprint $table) {
			$table->dropForeign('trainer_photos_user_id_foreign');
		});
		Schema::table('before_after_photos', function(Blueprint $table) {
			$table->dropForeign('before_after_photos_user_id_foreign');
		});
		Schema::table('training_package', function(Blueprint $table) {
			$table->dropForeign('training_package_user_id_foreign');
		});
		Schema::table('trainer_comments', function(Blueprint $table) {
			$table->dropForeign('trainer_comments_user_id_foreign');
		});
		Schema::table('trainer_comments', function(Blueprint $table) {
			$table->dropForeign('trainer_comments_commenter_foreign');
		});
	}
}