<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->string('uuid');
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->timestamp('email_verified_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}