<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentHistoriesTable extends Migration {

	public function up()
	{
		Schema::create('payment_histories', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('uuid');
			$table->boolean('status');
			$table->string('payement_type');
			$table->string('token');
			$table->longText('response');
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('subscription_plan_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payment_histories');
	}
}