<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAlimentsTable extends Migration {

	public function up()
	{
		Schema::create('aliments', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->decimal('stock')->nullable();
			$table->decimal('seuil')->nullable();
			$table->integer('id_unite')->unsigned()->nullable();
			$table->integer('unite_sortie')->unsigned()->nullable();
			$table->string('name', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->string('notificationSeuil', 10)->nullable()->default('0');
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('aliments');
	}
}