<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEquivalencesUnitesTable extends Migration {

	public function up()
	{
		Schema::create('equivalences_unites', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('id_uniteDepart')->unsigned()->nullable();
			$table->integer('id_uniteArrive')->unsigned()->nullable();
			$table->decimal('valeur')->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('equivalences_unites');
	}
}