<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePassagesVeterinairesTable extends Migration {

	public function up()
	{
		Schema::create('passages_veterinaires', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('id_utilisateurNiveau4')->unsigned()->nullable();
			$table->integer('prix')->nullable();
			$table->timestamp('date')->nullable();
			$table->string('anomalie', 255)->nullable();
			$table->string('prescription', 255)->nullable();
			$table->text('commentaire')->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('passages_veterinaires');
	}
}