<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerContactsTable extends Migration {

	public function up()
	{
		Schema::create('customer_contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('customer_id')->unsigned()->index();
			$table->integer('contact_id')->unsigned()->index();
			$table->tinyInteger('is_representative')->index()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('customer_contacts');
	}
}