<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingLocationsTable extends Migration {

	public function up()
	{
		Schema::create('booking_locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('booking_id')->unsigned()->index();
			$table->integer('location_id')->unsigned()->index();
			$table->datetime('date_from')->nullable()->index();
			$table->datetime('date_to')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('booking_locations');
	}
}