<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingPresencesTable extends Migration {

	public function up()
	{
		Schema::create('booking_presences', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('booking_id')->unsigned()->index();
			$table->integer('room_id')->unsigned()->index();
			$table->string('firstname', 200)->nullable()->index();
			$table->string('surname', 200)->nullable()->index();
			$table->string('nationality', 5)->nullable()->index();
			$table->string('gender', 5)->nullable()->index();
			$table->datetime('date_from')->nullable()->index();
			$table->datetime('date_to')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('booking_presences');
	}
}