<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomsTable extends Migration {

	public function up()
	{
		Schema::create('rooms', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 50);
			$table->string('description', 200)->index();
			$table->integer('capacity')->nullable()->index();
			$table->integer('comfort_type_id')->unsigned()->index();
			$table->integer('floor')->index();
			$table->integer('block_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('rooms');
	}
}