<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'phone', 'email', 'image', 'address', 'identity', 'license', 'vehicle_registration_number', 'bank_number', 'insurance_number', 'type', 'driver_type', 'password', 'active', 'latitude', 'longitude', 'city_id', 'api_token');

    public function addresses()
    {
        return $this->hasMany('App\Models\Address');
    }

    public function sliders()
    {
        return $this->hasMany('App\Models\Slider');
    }

    public function shifts()
    {
        return $this->hasMany('App\Models\Shift');
    }

    public function coupons()
    {
        return $this->hasMany('App\Models\Coupon');
    }

    public function rateDrivers()
    {
        return $this->hasMany('App\Models\Rate', 'driver_id');
    }

    public function rateFamilies()
    {
        return $this->hasMany('App\Models\Rate', 'family_id');
    }

    public function rates()
    {
        return $this->hasMany('App\Models\Rate', 'user_id');
    }

    public function payments()
    {
        return $this->hasMany('App\Models\Payment');
    }

    public function products()
    {
        return $this->hasMany('App\Models\Product');
    }

    public function clientNotificationS()
    {
        return $this->hasMany('App\Models\Notification', 'client_id');
    }

    public function familyNotificationS()
    {
        return $this->hasMany('App\Models\Notification', 'family_id');
    }

    public function driveNotifications()
    {
        return $this->hasMany('App\Models\Notification', 'driver_id');
    }

    public function wallets()
    {
        return $this->hasMany('App\Models\Wallet');
    }

    public function devices()
    {
        return $this->hasMany('App\Models\Device');
    }

    public function additions()
    {
        return $this->hasMany('App\Models\Addition');
    }

    public function clientOffers()
    {
        return $this->hasMany('App\Models\Offer', 'user_id');
    }

    public function driverOffers()
    {
        return $this->hasMany('App\Models\Offer', 'driver_id');
    }

    public function chats()
    {
        return $this->hasMany('App\Models\Chat', 'user_id');
    }

    public function secondChats()
    {
        return $this->hasMany('App\Models\Chat', 'second_user_id');
    }

    public function familyOrders()
    {
        return $this->hasMany('App\Models\Order', 'family_id');
    }

    public function clientOrders()
    {
        return $this->belongsToMany('App\Models\Order', 'client_id');
    }

    public function histories()
    {
        return $this->hasMany('App\Models\History', 'user_id');
    }

    public function driverHistories()
    {
        return $this->hasMany('App\Models\History', 'driver_id');
    }

    public function familyHistories()
    {
        return $this->hasMany('App\Models\History', 'family_id');
    }

}