<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChatsTable extends Migration {

	public function up()
	{
		Schema::create('chats', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('second_user_id')->unsigned();
			$table->string('photo', 255)->nullable();
			$table->string('name', 199)->nullable();
			$table->string('file', 255)->nullable();
			$table->string('voice', 255)->nullable();
			$table->text('message')->nullable();
			$table->decimal('latitude', 10,8)->nullable();
			$table->string('longitude')->nullable();
			$table->integer('order_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('chats');
	}
}