<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHistoriesTable extends Migration {

	public function up()
	{
		Schema::create('histories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->decimal('pull_request', 10,2)->nullable();
			$table->decimal('mainPrice', 10,2)->nullable();
			$table->decimal('net', 10,2)->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('title', 199)->nullable();
			$table->integer('order_id')->unsigned()->nullable();
			$table->integer('family_id')->unsigned();
			$table->integer('driver_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('histories');
	}
}