<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('username');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('apikey');
			$table->string('role');
			$table->float('balance')->default('0');
			$table->text('avatar')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}