<?php

namespace Product;

use Illuminate\Database\Eloquent\Model;

class UserInput extends Model 
{

    protected $table = 'user_inputs';
    public $timestamps = true;
    protected $fillable = array('instruction_text', 'field_section_title', 'buy_section_titlle', 'item_section_title', 'payment_section_title', 'voucher_section_title');

    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

    public function fields()
    {
        return $this->hasMany('UserInput\Fields', 'user_input_id');
    }

}