<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'slug', 'is_active', 'ordered');

	public function products()
	{
		return $this->hasMany('App\Models\Product', 'category_id');
	}

}