<?php

namespace Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ItemSection extends Eloquent {

	protected $table = 'item_sections';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'title', 'ordered', 'is_active');

	public function product()
	{
		return $this->belongsTo('App\Models\Product', 'product_id');
	}

	public function items()
	{
		return $this->hasMany('Products\Item');
	}

}