<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->integer('image_id')->nullable();
			$table->string('slug')->nullable();
			$table->mediumText('description')->nullable();
			$table->string('categories')->nullable();
			$table->string('images')->nullable();
			$table->string('vendors')->nullable();
			$table->string('distributor')->nullable();
			$table->string('suppliers')->nullable();
			$table->integer('last_modified_by')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}