<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBooksTable extends Migration {

	public function up()
	{
		Schema::create('books', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->index();
			$table->string('annotation');
			$table->string('isbn')->index();
			$table->bigInteger('publisher_id')->index();
			$table->string('publish_year')->index();
			$table->text('citation');
			$table->string('pages');
			$table->string('chapters');
			$table->bigInteger('category_id')->index();
			$table->string('picture')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('books');
	}
}