<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePathPlacesTable extends Migration {

	public function up()
	{
		Schema::create('path_places', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('place_id')->unsigned()->nullable();
			$table->bigInteger('path_id')->unsigned();
			$table->tinyInteger('status');
			$table->boolean('is_current')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('path_places');
	}
}