<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('catgories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fav_places', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fav_places', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('religious_evidences', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('religious_dates', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paths', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('path_places', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('path_places', function(Blueprint $table) {
			$table->foreign('path_id')->references('id')->on('paths')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ritual_categories', function(Blueprint $table) {
			$table->foreign('ritual_type_id')->references('id')->on('ritual_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ritual_step_places', function(Blueprint $table) {
			$table->foreign('ritual_step_id')->references('id')->on('ritual_steps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_category_id_foreign');
		});
		Schema::table('fav_places', function(Blueprint $table) {
			$table->dropForeign('fav_places_client_id_foreign');
		});
		Schema::table('fav_places', function(Blueprint $table) {
			$table->dropForeign('fav_places_place_id_foreign');
		});
		Schema::table('religious_evidences', function(Blueprint $table) {
			$table->dropForeign('religious_evidences_place_id_foreign');
		});
		Schema::table('religious_dates', function(Blueprint $table) {
			$table->dropForeign('religious_dates_place_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_place_id_foreign');
		});
		Schema::table('paths', function(Blueprint $table) {
			$table->dropForeign('paths_client_id_foreign');
		});
		Schema::table('path_places', function(Blueprint $table) {
			$table->dropForeign('path_places_place_id_foreign');
		});
		Schema::table('path_places', function(Blueprint $table) {
			$table->dropForeign('path_places_path_id_foreign');
		});
		Schema::table('ritual_categories', function(Blueprint $table) {
			$table->dropForeign('ritual_categories_ritual_type_id_foreign');
		});
		Schema::table('ritual_step_places', function(Blueprint $table) {
			$table->dropForeign('ritual_step_places_ritual_step_id_foreign');
		});
	}
}