<?php

namespace App;

class Person extends Eloquent {

	protected $table = 'people';
	public $timestamps = true;

	public function has_been_a_creator_of_series()
	{
		return $this->belongsToMany('App\Serie', 'creator_serie', 'serie_id', 'creator_id');
	}

	public function has_been_a_star_of_series()
	{
		return $this->belongsToMany('App\Serie', 'star_serie', 'serie_id', 'star_id');
	}

	public function has_been_a_creator_of_films()
	{
		return $this->belongsToMany('App\Film', 'creator_film', 'film_id', 'creator_id');
	}

	public function has_been_a_star_of_films()
	{
		return $this->belongsToMany('App\Film', 'star_film', 'film_id', 'star_id');
	}

}