<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('age')->nullable();
			$table->string('phone', 100)->nullable();
			$table->string('password', 8)->nullable();
			$table->tinyInteger('block')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}