<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInfosTable extends Migration {

	public function up()
	{
		Schema::create('infos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('key')->unique();
			$table->string('value')->nullable();
			$table->enum('type', array('image', 'text'))->nullable();
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('infos');
	}
}