<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function packages()
	{
		return $this->hasManyThrough('App\Models\Package', 'App\Models\Purchase');
	}

	public function purchases()
	{
		return $this->hasMany('App\Models\Purchase');
	}

	public function school()
	{
		return $this->belongsTo('App\Models\School');
	}

	public function notes()
	{
		return $this->hasMany('App\Models\Note');
	}

}