<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchoolsTable extends Migration {

	public function up()
	{
		Schema::create('schools', function(Blueprint $table) {
			$table->increments('id');
			$table->string('key');
			$table->string('subdomain');
			$table->integer('user_id')->unsigned()->nullable();
			$table->boolean('is_active');
			$table->string('name');
			$table->text('notes')->nullable();
			$table->json('style_meta')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('schools');
	}
}