<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVesselsTable extends Migration {

	public function up()
	{
		Schema::create('vessels', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('name', 255)->nullable();
			$table->text('desc')->nullable();
			$table->string('vessel_number', 255)->unique()->nullable();
			$table->integer('width')->nullable();
			$table->integer('created_by')->unsigned();
			$table->integer('vessel_model')->unsigned();
			$table->mediumText('length')->nullable();
			$table->integer('speed')->nullable();
			$table->string('image', 255)->nullable();
			$table->enum('vessel_type', array('1', '2', '3'));
			$table->enum('grouping', array('yes', 'no'))->nullable();
			$table->integer('max_passengers')->nullable();
			$table->integer('default_route')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vessels');
	}
}