<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function permissions()
	{
		return $this->belongsToMany('App\Models\Permission', 'role_permissions', 'role_id', 'permission_id');
	}

}